package floweditor.component;

import java.awt.Color;

import com.ibm.graph.ext.visual.VisualVertex;

/**
 *  Klasse die (default) graphische Darstellung einer
 *  Komponente definiert.
 */
public class DefaultGraph extends VisualVertex
    implements CompGraph
{    
    
    public DefaultGraph (Component component, 
			 String    label,
			 Color     fillColor)
    {
	super (VisualVertex.ELLIPSE,   // vertex's shape 
	       fillColor,              // fill color      
	       Color.black,            // border color
	       false,                  // text to be printed isn't vertex's key
	       label,                  // the text to be shown whitin Ellipse
	       Color.black);           // text color
	
	_component = component;
	
	setSize (_width, _height);
	
	try {
	    setMarginTop ((_height - getFontSizeDefault ())/2 );
	    setMarginBottom ((_height - getFontSizeDefault ())/2 );
	} catch (Exception e) {
	    e.printStackTrace ();
	}
	
    }
    
    ///////////////////////////////////////
    //    Implementation of CompGraph    //
    ///////////////////////////////////////
    
    /** berprft ob PARTICIPANT ein Knoten ist.
	@return true immer, da PARTICIPANT-Komponente
	als Knoten dargestellt wird.
    */
    public boolean isVertex () 
    {
	return true;
    }
    
    /**
     *  Gibt die bergeordnete Komponente zurck, die durch diesen
     *  Graph dargestellt wird.
     */
    public Component getComponent () 
    {
	return _component;
    }
    
    Component _component;

    private int _width  = 80;
    private int _height = 50;
}


