package floweditor.component;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;  

import java.util.Hashtable;
import java.util.Enumeration;

import javax.swing.JMenuItem;
import javax.swing.JMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;


import com.ibm.xml.parser.InsertableElement;

import floweditor.system.ElementBox;
import floweditor.util.Log;

public class DefaultPopupMenu 
    extends CompPopupMenu
{
    Component        _comp;
    CompFactory      _factory;
    DefaultTreeModel _treeModel;
    
    
    public DefaultPopupMenu (Component comp, JTree tree, 
			     ElementBox elembox, int row) 
    {
	super ();
	Log.file(1,"CompPopupMenu", 
		 "CompPopupMenu(Component, JTree, ElementBox, int)" );
	_comp = comp;
	_factory   = (CompFactory) _comp.getFactory ();
	_treeModel = _factory.getTreeModel ();
	addMenuItems (tree, elembox, row);
	// int countChild = _parent.getChildCount ();
    }

    private void addMenuItems (JTree tree, ElementBox elembox, int row) 
    {
	//test
	int childCount = _comp.getChildCount ();
	System.err.println ("Component " + _comp.getTagName () +
			    " hat " + childCount + " Kinder");
	/* 
	 * get the appendable Children to be listed in Menu "append"
	 *  */
	Log.file(2, "CompPopupMenu", 
		 "addMenuItems(JTree, ElementBox, int)", 
		 "add append menu");
	JMenu append = new JMenu ("append");
	String[] compSuppressedItems = _comp.getSuppressedPopupItems();
	Hashtable appendables 
	    = _comp.getAppendableElements (compSuppressedItems);    
	InsertableElement iElem; 
	Enumeration appendItems = appendables.elements ();
	while (appendItems.hasMoreElements ()) {
	    iElem = (InsertableElement) appendItems.nextElement ();
	    Log.file(2, "CompPopupMenu", "addMenuItems()", "   " + iElem.name);
	    if (iElem.status == true) {
	    
		JMenuItem appendItem = new JMenuItem (iElem.name);
		appendItem.addActionListener 
		    (new AppendListener (_comp, 
					 iElem.name,
					 tree,
					 _treeModel,
					 elembox,
					 row));
		append.add (appendItem);
	    }  //if
	}  // while
	this.add (append);

	/* 
	 * get those insertable neighbour Components, which are before
	 * this one
	 *  */
	boolean isDocumentNode = (_comp.getParentNode() == _factory);
	if (!isDocumentNode) {
	    Log.file(2, "CompPopupMenu", "addMenuItems()", 
		     "add insert before menu");
	    JMenu insert = new JMenu ("insert before");
	    Component parentComp = (Component) _comp.getParentNode();
	    String[] parentSuppressedItems 
		= parentComp.getSuppressedPopupItems();
	    Hashtable insertables 
		= parentComp.getInsertableElementsBeforeChild 
		(_comp, parentSuppressedItems);
	    Enumeration insertItems = insertables.elements ();
	    while (insertItems.hasMoreElements ()) {
		iElem = (InsertableElement) insertItems.nextElement ();
		Log.file(2, "CompPopupMenu", "addMenuItems()", 
			 "   " + iElem.name);
		if (iElem.status == true) {
		    JMenuItem insertItem = new JMenuItem (iElem.name);
		    insertItem.addActionListener 
			(new InsertListener (_comp, 
					     iElem.name, 
					     tree,
					     _treeModel,
					     elembox,
					     row) );
		    insert.add (insertItem);
                }
            }    // while
	    this.add (insert);

	    /* 
	     * If this Component last Child of parent, remove it
	     *  */
	    
	    Component lastChild = (Component) parentComp.getLastChild ();
	    if (_comp == lastChild) {
		Log.file(2, "CompPopupMenu", "addMenuItems()", 
			 "add remove menu item");
       
		String removeItem = "remove";
		JMenuItem remove  = new JMenuItem (removeItem);
		remove.addActionListener (new RemoveListener (_comp,
							      removeItem, 
							      tree,
							      _treeModel,
							      elembox,
							      row));
		add (remove);
	    }
	    
	}  // if
	 
    } // addMenuItems()

}
