package floweditor.pool.MODEL.APPLICATION;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultTreeModel;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.DTD;

import floweditor.util.Log;
import floweditor.component.Component;
import floweditor.component.CompForm;
import floweditor.component.CompAttributeEditor;
import floweditor.component.CompGraphEditor;
import floweditor.component.DefaultGraphEditor;
import floweditor.component.CompGraph;
import floweditor.component.DefaultGraph;

import floweditor.component.NotWellFormedDocument;
import floweditor.component.CompEventHandler;

public class APPLICATION 
    extends Component 
{

    /** Methode fr die Instanzierung eine APPLICATION-Komponente.
     */
    public APPLICATION () 
    {
	super ("APPLICATION");
    }


   /** Gibt GUI der Instanz zurck. 
     * erzeugt eine GUI in Formularform, mit der Attribute und
     * Substrukturen manipuliert werden knnen */
    public CompForm getCompForm (DefaultTreeModel treemodel)
    {
	if (_form == null) {
	    _form = new Formular ();
	}
	return _form;
    }

    /**
     * gibt die graphische Instanz dieser Komponenten-Instanz
     * zurck. Mehrmalige Aufrufe geben immer das selbe Objekt zurck */ 
    public CompGraph getCompGraph () 
    {
	if (_graph == null) {
            String idName = hasIdAttr();
	    Color  color  = Color.cyan;
            if ( idName != null) {
                String label = getAttribute (idName);
                _graph = new DefaultGraph (this, label, color);
            } else {
                String label = getTagName ();
                _graph = new DefaultGraph (this, label, color);               
            }
	}
	return _graph;
    }


    /** definiert, welche Elemente diese Komponente nicht ber das
     * PopupMenu eingefgt bekommen mchte 
     * @see floweditor.component.DefaultPopupmenu
     *  */
    public  String[] getSuppressedPopupItems () 
    {
        String[] suppressedItems = {DTD.CM_PCDATA, 
				    DTD.CM_EOC, 
				    DTD.CM_ERROR};
        return suppressedItems;
    }

    
    /** Attribute einer Application-Komponente
	PARAM Referenz auf ein Data-Element, IDREF oder URI-Adresse, optional
	ID exklusiver Name
	NAME beliebig, optional 
	TOOLNAME Bezeichnung einer Applikation, beliebig, optional
    */
    String PARAM = "PARAM";
    String ID    = "ID";
    String NAME  = "NAME";
    String TOOLNAME  = "TOOLNAME";
 
    /** berschreibt die Methode in @see Component. Methode gibt ein 
     *  JComponent-Object zurck, die die Schnittstelle
     *  eines Attributes von dieser Komponente (APPLICATION) darstellt. 
     *  Fr Attribute die besondere Behandlung bentigen (also wenn 
     *  es sich um Attribute handelt, die nur bestimmte Werte 
     *  zugewiesen bekommen drfen) gibt es spezielle Klassen,
     *  die die jeweilige Schnittstelle darstellen.
     */
    public JComponent createAttributeField (AttDef attDef, String attrName) 
        throws floweditor.component.UnknownAttributeException
    {
        Log.file (1, "pool.MODEL.APPLICATION", "createAttributeField (String)");
	if (attrName.equals (PARAM)) 
	    return new AttrPARAM (this, attDef, 15);
	else
            return super.createAttributeField (attDef, attrName);
    }


    /** ber diese Methode werden alle EventHandler benachrichtigt,
     *  dass sie ihre Daten auf Konsistenz berprfen sollen (Nachricht
     *  wird propagiert).
     */
    public void checkForConsistency () 
        throws NotWellFormedDocument
    {
        DTD dtd  = getFactory().getDTD ();
        /* now do syntax-check */
        if ( hasChildNodes ()) {
            Enumeration children = this.children ();
            while (children.hasMoreElements () ){
                Component child    = (Component) children.nextElement ();
                if (dtd.validate (child) == null) {
                    child.checkForConsistency ();
		} else {
                    //FIXME which Node is wrong? 
                    throw new NotWellFormedDocument ("Syntax error occured: " +
                                                     "Element "+child.getTagName()+
                                                     " wrong defined." +
                                                     " Attribute or child node" +
                                                     " missing.\n" +
                                                     "Unable to save",
                                                     child);
                }
            }  /* end while */
        } /*  end if (1) */
        
        /* after correct syntax, check the semantics */
        Vector _handlerList = getEventHandler();
	int N = _handlerList.size();
	for(int i = 0; i < N; i++) {
		CompEventHandler handler 
		    = (CompEventHandler) _handlerList.elementAt(i);
		handler.checkForConsistency ();
	}
    }

    /** Innere Klasse die das Form-Fenster der
	APPLICATION-Komponente definiert.
    */
    private class Formular extends CompForm {

	public Formular () 
	{
	    super();
	    
	    CompAttributeEditor attrEditor 
		= new CompAttributeEditor (APPLICATION.this);
	    JScrollPane panelOne = new JScrollPane (attrEditor);
	    
	    graphEditor 
		= new DefaultGraphEditor (APPLICATION.this,
					  8, 8, 140, 100);
	    panelTwo = new JScrollPane (graphEditor);
	    
	    addToTabPane (panelOne, "APPLICATION ATTRIBUTES");
            addToTabPane (panelTwo, "APPLICATION GRAPHEDITOR");
	    
	}
	
	/** Darstellung in GraphEditor aktualisieren wenn eine 
	    Kind-Komponente entfernt wurde.
	*/
	public void update () 
	{
	    graphEditor.update ();
	}

	public void checkData () {
	    ;
	}
	
	JScrollPane     panelTwo;
	CompGraphEditor graphEditor;
   }
   
    Formular  _form = null;
    CompGraph _graph = null;
}


