package floweditor.pool.MODEL.SUBFLOW;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Enumeration;
import javax.swing.JComboBox;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.TXElement;

import floweditor.component.CompFactory;
import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.Log;

/** abstract Klasse, von der sich alle weiteren AttributFelder
 *  ableiten */
public class AttrREF
    extends javax.swing.JComboBox
    implements CompEventHandler
{
    Component _owner;
    AttDef    _attDef;
    Component _refComp;  // which Component is referenced by 
    boolean   _isValid;
    Component _workflow; // predecessor of component owner
    String    _wkfId;
    static String NOVALUE = " --- ";

    protected AttrREF (Component owner, AttDef attDef, int columns) {
	// an ID must be set
	// FIXME
	super();
	_owner    = owner;
	_attDef   = attDef;
	_refComp  =  null;
	_isValid  = false;

	String attributeName  = _attDef.getName();
	String attributeValue = _owner.getAttribute (attributeName);
	String ownerName    = _owner.getTagName();


	Log.file (1,"AttrREF","AttrREF (..) ", 
		  ownerName + "::" +  
		  attributeName + "::" + 
		  attributeValue); 

        /* add Dummy-Field: initial value*/
        this.addItem (NOVALUE);
	
	// find ancestor workflow and his id
	_workflow = (Component) _owner.searchAncestors("WORKFLOW");
	_wkfId    = _workflow.getAttribute ("ID");

	// Liste aller Komponenten der Sorte "WORKFLOW"
	CompFactory factory = (CompFactory) _owner.getFactory ();
	Component    parent = (Component) factory.getChildAt (0);
	TXElement [] workflows = parent.searchDescendantsAll ("WORKFLOW");

	for (int i = 0; i < workflows.length; i++) {
	    String idValue = workflows [i].getAttribute ("ID");
	    _isValid = _isValid || (idValue.equals (attributeValue));
	    if ( !idValue.equals (_wkfId))
		this.addItem (idValue);
	}

	if (_isValid) {
	    this.setSelectedItem (attributeValue); 
        } else {
             this.setSelectedIndex (0); 
        }
        

        this.addActionListener( new ActionListener () {
                public void actionPerformed(ActionEvent e) {
                    AttrREF  combobox = AttrREF.this;
                    Component component = combobox._owner;
                    String     attrName = (combobox._attDef).getName();
                    String attrValue 
                        = (String) combobox.getSelectedItem();
                    /* attribute must get a value 
                       (attrType == REQUIRED) */
                    if (attrValue == NOVALUE) { 
                        // no value for this attribute
                        component.setAttribute (attrName, null);
                    }
		    else 
			component.setAttribute(attrName, attrValue);
                    component.changeAttributeEvent((CompEventHandler) combobox ,
                                                   attrName, 
                                                   attrValue);
                }
            }   );
	
    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {

    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
        Log.file(1,"AttrREF", "attributeChangedEvent(..)");
        if ((_owner == owner) && (attrname == _attDef.getName())){
            this.setSelectedItem (value);
        }
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
        Log.file (1, "SUBFLOW.AttrREF", "checkForConsistency()", _owner);	
	String attrValue = (String) this.getSelectedItem ();
	if (attrValue == null || ((attrValue.trim()).length () == 0)) {
	    throw new NotWellFormedDocument ("SUBFLOW.AttrREF \n" +
					     "Error: no value defined " +
					     "for reference attribute! \n" +
					     "Choose one of the listed refs",
					     _owner);
	} else {
	    if (attrValue.equals (_wkfId))
		throw new NotWellFormedDocument ("SUBFLOW.AttrREF \n" +
						 "Error:bad argument for " +
						 "reference! ID from Workflow-" +
						 "parent is no valid value \n" +
						 "Please choose anothers Wkf-Ref",
						 _owner);
	    Component wkf = _owner.checkID (attrValue);
	    if (wkf == null) 
		throw new NotWellFormedDocument ("SUBFLOW.AttrREF \n" +
						 "Error: Workflow with this ID " +
						 "doesn't exist! \n" +
						 "Choose another ID",
						 _owner);
	    
	} /* end if (1)*/
    }

}
