package floweditor.pool.MODEL.TRANSITION;

import java.awt.Color;

import com.ibm.graph.ext.visual.VisualVertex;
import com.ibm.graph.ext.visual.VisualEdge;

import floweditor.component.Component;
import floweditor.component.CompGraph;

/**
 *   Innere Klasse die die graphische Darstellung der
 *  TRANSITION-Komponente definiert.
*/
public class TransitionGraph 
    extends VisualEdge
    implements CompGraph
{
    
    public TransitionGraph (Component component, 
			    VisualVertex actFrom, VisualVertex actTo,
			    Color color)
    {
	super (actFrom, actTo, true, 
	       VisualEdge.STRAIGHT_LINE,
	       color);

	_component = component;
    }
    
    ///////////////////////////////////////
    //    Implementation of CompGraph    //
    ///////////////////////////////////////
    
    /** berprft ob TRANSITION ein Knoten ist.
	@return false immer, da TRANSITION-Komponente
	innerhalb einer WORKFLOW als Kante dargestellt wird.
    */
    public boolean isVertex () 
    {
	return false;
    }
    
    public Component getComponent () {
	
	return _component;
    }

    Component _component;
}






