package floweditor.util;

import java.io.IOException;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Date;


public class Log 
    implements DebugConst
{
    static Writer theLogFile = null;
    
    synchronized public static 
	void file(int level, String obj, String method) 
    {
	if (DEBUG >= level) {
	    openFile();
	    try {
		theLogFile.write(obj);
		theLogFile.write("::");
		theLogFile.write(method);
		theLogFile.write("\n");
		theLogFile.flush();
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
    }
    
    synchronized public static 
	void file(int level, String obj, String method, String mesg) 
    {
	if (DEBUG >= level) {
	    openFile();
	    try {
		theLogFile.write(obj);
		theLogFile.write("::");
		theLogFile.write(method);
		theLogFile.write(":  ");
		theLogFile.write(mesg);
		theLogFile.write("\n");
		theLogFile.flush();
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
    }

    synchronized public static 
	void file(int level, String obj, String method, String mesg, 
		  Object any) 
    {
	if (DEBUG >= level) {
	    openFile();
	    try {
		theLogFile.write(obj);
		theLogFile.write("::");
		theLogFile.write(method);
		theLogFile.write(":  ");
		theLogFile.write(mesg);
		theLogFile.write(any.toString());
		theLogFile.write("\n");
		theLogFile.flush();
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
    }

    private static void openFile() {
	if (theLogFile == null) {
	    try {
		// Date date = new Date();
		// String str = date.toString();
		// str = str.replace(' ', '_');
		// String name = "/tmp/Logfile_" + str + ".txt" ;
		String name  = "/tmp/Logfile.txt";
		System.err.println(" ----- OPEN LOGFILE --- " + name + " ---");
		theLogFile = new FileWriter(name);
	    } catch (Exception e) {
		e.printStackTrace();
		theLogFile = new NullWriter();
	    }
	}
    } 

    synchronized public static 
	void file(int level, String obj, String method, Object mesg) 
    {
	file(level, obj, method, mesg.toString());
    }

}

class NullWriter 
    extends Writer
{
    NullWriter() {}

    public void write(int c) 
	throws IOException 
    {
    }

    public void write(char[] cbuf)
	throws IOException 
    {
    }

    public void write(char[] cbuf,
			       int off,
			       int len)
	throws IOException
    {
    }
    
    public void write(String str)
	throws IOException
    {
    }

    public void write(String str,
		      int off,
		      int len)
	throws IOException
    {
    }
    
    public void flush()
	throws IOException
    {
    }

    public void close()
	throws IOException
    {
    }
}
